(function ($) {
  $(function () {
    var $section = $('.map-section');
    if (!$section.length) return;

    var $baseCol   = $section.find('.col.tbilisi').first();
    if (!$baseCol.length) return;

    var $baseInner = $baseCol.children('.col-inner').first();
    if (!$baseInner.length) return;

    var $routes = $section.find('.col.mtskheta, .col.zhinvali, .col.ananuri, .col.pasanauri');
    var $pins   = $section.find('.pins');

    var map = {
      'tb-pin': 'tbilisi',
      'mt-pin': 'mtskheta',
      'zhi-pin': 'zhinvali',
      'ana-pin': 'ananuri',
      'pas-pin': 'pasanauri'
    };

    var PANEL_DURATION = 450;
    var isOpen = false;
    var isTransitioning = false;
    var currentRoute = 'tbilisi';

    $baseCol.addClass('is-base-route');
    $baseInner.css('position', 'relative');

    var $panel = $(
      '<div class="route-panel">' +
        '<button type="button" class="route-panel-close" aria-label="Close route panel">×</button>' +
        '<div class="route-panel-content"></div>' +
      '</div>'
    );
    $baseInner.append($panel);
    var $panelContent = $panel.find('.route-panel-content');

    function setActivePin(routeClass) {
      $pins.removeClass('is-active');
      if (!routeClass || routeClass === 'tbilisi') {
        $section.find('.tb-pin').addClass('is-active');
        return;
      }
      $.each(map, function (pinClass, colClass) {
        if (colClass === routeClass) $section.find('.' + pinClass).addClass('is-active');
      });
    }

    function setBaseMode(isPanelOpen) {
      $baseCol.toggleClass('is-panel-open', !!isPanelOpen);
    }

    function getRouteContent(routeClass) {
      var $col = $routes.filter('.' + routeClass).first();
      var $inner = $col.children('.col-inner').first();
      return $inner.length ? $inner.html() : '';
    }

    function animateOpen() {
      $panel.removeClass('slide-out').addClass('slide-in-start');
      void $panel[0].offsetHeight;
      $panel.addClass('slide-in-active').removeClass('slide-in-start');
    }

    function animateClose() {
      $panel.removeClass('slide-in-active slide-in-start').addClass('slide-out');
    }

    function animateBaseOut(callback) {
      $baseCol.removeClass('base-leave-active base-leave-start');
      void $baseCol[0].offsetHeight;
      $baseCol.addClass('base-leave-start');
      void $baseCol[0].offsetHeight;
      $baseCol.addClass('base-leave-active').removeClass('base-leave-start');
      setTimeout(function () {
        $baseCol.removeClass('base-leave-active');
        if (callback) callback();
      }, PANEL_DURATION);
    }

    function animateTbilisiIn() {
      $baseCol.removeClass('base-enter-active base-enter-start');
      void $baseCol[0].offsetHeight;
      $baseCol.addClass('base-enter-start');
      void $baseCol[0].offsetHeight;
      $baseCol.addClass('base-enter-active').removeClass('base-enter-start');
      setTimeout(function () { $baseCol.removeClass('base-enter-active'); }, PANEL_DURATION);
    }

    function openPanel(routeClass) {
      var html = getRouteContent(routeClass);
      if (!html) return;
      currentRoute = routeClass;
      isOpen = true;
      setBaseMode(true);
      $panelContent.html(html);
      animateOpen();
      setActivePin(routeClass);
    }

    function closePanel(nextRoute, callback) {
      if (!isOpen) {
        if (nextRoute === 'tbilisi') setBaseMode(false);
        if (callback) callback();
        return;
      }
      isOpen = false;
      animateClose();
      setTimeout(function () {
        $panelContent.empty();
        $panel.removeClass('slide-out');
        if (nextRoute === 'tbilisi') {
          setBaseMode(false);
          currentRoute = 'tbilisi';
          animateTbilisiIn();
        } else {
          setBaseMode(true);
        }
        if (callback) callback();
      }, PANEL_DURATION);
    }

    function goToRoute(routeClass) {
      if (isTransitioning || !routeClass) return;
      if (routeClass === currentRoute && ((routeClass !== 'tbilisi' && isOpen) || routeClass === 'tbilisi')) return;

      isTransitioning = true;

      // თბილისიდან სხვაზე გადასვლა — animate base out, მერე panel in
      if (currentRoute === 'tbilisi' && routeClass !== 'tbilisi') {
        animateBaseOut(function () {
          openPanel(routeClass);
          setTimeout(function () { isTransitioning = false; }, 10);
        });
        return;
      }

      // სხვა→სხვა ან სხვა→თბილისი
      closePanel(routeClass, function () {
        if (routeClass !== 'tbilisi') {
          openPanel(routeClass);
        } else {
          setActivePin('tbilisi');
          currentRoute = 'tbilisi';
        }
        setTimeout(function () { isTransitioning = false; }, 10);
      });
    }

    $panel.on('click', '.route-panel-close', function (e) {
      e.preventDefault();
      goToRoute('tbilisi');
    });

    $section.on('click', '.pins', function (e) {
      e.preventDefault();
      var routeClass = null;
      $.each(this.className.split(/\s+/), function (i, cls) {
        if (map[cls]) { routeClass = map[cls]; return false; }
      });
      goToRoute(routeClass);
    });

    setActivePin('tbilisi');
  });
})(jQuery);







/* ================================
 * SEASON TOGGLE – SUMMER/WINTER
 * ================================ */
document.addEventListener("DOMContentLoaded", function () {
    const body = document.body;
    const btn  = document.querySelector(".season-toggle-btn");
    const STORAGE_KEY = "seasonMode"; // ვინახავთ sessionStorage–ში

    // === სეზონის განსაზღვრა კალენდრის მიხედვით ===
    function detectSeasonByDate() {
        const now   = new Date();
        const month = now.getMonth() + 1; // 0-based → 1-12

        // გაზაფხული + ზაფხული -> summer
        // მარტი(3), აპრილი(4), მაისი(5), ივნისი(6), ივლისი(7), აგვისტო(8)
        if (month >= 3 && month <= 8) {
            return "summer";
        }

        // შემოდგომა + ზამთარი -> winter
        return "winter";
    }

    // === mode-ის დაყენება body-ზე ===
    function applyMode(mode) {
        if (mode === "summer") {
            body.classList.add("summer-mode");
        } else {
            body.classList.remove("summer-mode");
        }
    }

    // 1) ვცდილობთ წავიკითხოთ sessionStorage–დან
    let currentMode = sessionStorage.getItem(STORAGE_KEY);

    // 2) თუ არაფერი წერია (პირველი ჩატვირთვა ამ ტაბზე) → კალენდრის მიხედვით ავარჩევთ
    if (!currentMode) {
        currentMode = detectSeasonByDate();
        applyMode(currentMode);
        // ჩავწეროთ, რომ შემდეგ გვერდებზე იგივე დარჩეს ამ სესijoje
        sessionStorage.setItem(STORAGE_KEY, currentMode);
    } else {
        // sessionStorage–ში რაც ეწერა, იმას ვაყენებთ
        applyMode(currentMode);
    }

    // 3) Manual toggle ღილაკით
    if (btn) {
        btn.addEventListener("click", function (e) {
            e.preventDefault();

            // toggle კლასის
            const nowSummer = body.classList.toggle("summer-mode");
            const newMode   = nowSummer ? "summer" : "winter";

            // დავიმახსოვროთ მხოლოდ ამ სესიისთვის
            sessionStorage.setItem(STORAGE_KEY, newMode);
        });
    }
});



/* ================================
 * CUSTOM MENU – STAGGER OPEN/CLOSE
 * ================================ */
jQuery(function($){

  var $menu  = $('.custom-menu');
  var $body  = $('body');
  var $icon  = $('.menu-icon');
  var $cols  = $menu.find('.menu-col');

  var isAnimating    = false;
  var stagger        = 120;
  var animDuration   = 300;

  function openMenu() {
    if (isAnimating || $menu.hasClass('active')) return;
    isAnimating = true;

    $menu.addClass('active');
    $body.addClass('menu-open');
    $icon.addClass('active');

    $cols.removeClass('is-visible is-hidden');

    $cols.each(function(index){
      var $col = $(this);
      setTimeout(function(){
        $col.addClass('is-visible');
        if (index === $cols.length - 1) {
          isAnimating = false;
        }
      }, index * stagger);
    });
  }

  function closeMenu(callback) {
    if (isAnimating || !$menu.hasClass('active')) {
      if (callback) callback();
      return;
    }

    isAnimating = true;

    $cols.each(function(i){
      var index = ($cols.length - 1) - i;
      var $col = $cols.eq(index);

      setTimeout(function(){
        $col.removeClass('is-visible').addClass('is-hidden');

        if (i === $cols.length - 1) {
          setTimeout(function(){
            $menu.removeClass('active');
            $body.removeClass('menu-open');
            $icon.removeClass('active');
            isAnimating = false;

            if (callback) callback();

          }, animDuration);
        }
      }, i * stagger);
    });
  }


  /* -------- BUTTON OPEN/CLOSE -------- */

  $('.menu-button').on('click', function(e){
    e.preventDefault();
    if ($menu.hasClass('active')) {
      closeMenu();
    } else {
      openMenu();
    }
  });


  /* -------- LINK CLICK → CLOSE + REDIRECT -------- */

  $('.custom-menu a').on('click', function(e){
    var link = $(this).attr('href');

    // არ ვაჩერებთ ლინკს, უბრალოდ ვადიანებთ გადასვლას
    e.preventDefault();

    closeMenu(function(){
      window.location.href = link;
    });
  });


  /* -------- CLOSE BUTTON -------- */

  $('.custom-menu__close').on('click', function(e){
    e.preventDefault();
    closeMenu();
  });

});



/* ================================
 * jQuery removeClass override – nav-dark დაცვისთვის
 * ================================ */
(function($) {

  var originalRemoveClass = $.fn.removeClass;

  $.fn.removeClass = function(value) {

    // თუ არგუმენტი არ არის სტრინგი → სტანდარტული ქცევა
    if (!value || typeof value !== 'string') {
      return originalRemoveClass.apply(this, arguments);
    }

    // თუ nav-dark საერთოდ არ ფიგურირებს → არაფერი არ ვცვლით
    if (value.indexOf('nav-dark') === -1) {
      return originalRemoveClass.apply(this, arguments);
    }

    var $all = this;

    // ელემენტები, რომლებიც არიან .custom-menu-ს შიგნით
    var $insideCustomMenu = $all.filter(function() {
      return $(this).closest('.custom-menu').length > 0;
    });

    // ელემენტები, რომლებიც არ არიან .custom-menu-ს შიგნით
    var $outsideCustomMenu = $all.not($insideCustomMenu);

    // თუ არც ერთი ელემენტი არ არის .custom-menu-ში → სტანდარტული removeClass
    if (!$insideCustomMenu.length) {
      return originalRemoveClass.apply(this, arguments);
    }

    // --- 1) ელემენტები .custom-menu-ს გარეთ → removeClass როგორც ადრე ---
    if ($outsideCustomMenu.length) {
      originalRemoveClass.call($outsideCustomMenu, value);
    }

    // --- 2) ელემენტები .custom-menu-ს შიგნით ---
    // აქ nav-dark დაცული უნდა იყოს, მაგრამ სხვა კლასები შეიძლება მოიხსნას
    var classes = value.split(/\s+/);
    var filtered = classes.filter(function(c) {
      return c && c !== 'nav-dark';
    });
    var filteredValue = filtered.join(' ');

    if (filteredValue) {
      originalRemoveClass.call($insideCustomMenu, filteredValue);
    }
    // nav-dark-ს შეგნებულად *არ* ვშლით

    return this; // chainability
  };

})(jQuery);



/* ================================
 * FLICKITY – CINEMATIC SLOW GLIDE + PARALLAX
 * ================================ */
document.addEventListener('DOMContentLoaded', function () {
  var $ = jQuery;

  // ვინახავთ ორიგინალ lazyFlickity-ს
  var originalLazyFlickity = $.fn.lazyFlickity;

  // wrapper:
  // 1) ცვლის motion-ს (cinematic glide)
  // 2) ამატებს parallax-ს სურათებზე
  $.fn.lazyFlickity = function (options) {
    options = options || {};

    /* -----------------------------------
       1) CINEMATIC SLOW GLIDE
       ----------------------------------- */
var isMobile = window.matchMedia('(max-width: 768px)').matches;

if (isMobile) {
  // ✅ მობაილზე უფრო სწრაფი/მკვეთრი snap
  options.selectedAttraction = 0.04;
  options.friction           = 0.28;

  // ✅ ნაკლები შემთხვევითი swipe სქროლზე
  options.dragThreshold      = 18;
  options.touchVerticalScroll = true; // Flickity v2 (თუ მუშაობს შენთან)
} else {
  // Desktop cinematic
  options.selectedAttraction = 0.006;
  options.friction           = 0.16;
}

    var $carousel = this;

    // ვიძახებთ ორიგინალ lazyFlickity-ს
    var result = originalLazyFlickity.call($carousel, options);

    /* -----------------------------------
       2) PARALLAX SHIFT სურათებზე
       ----------------------------------- */
    setTimeout(function () {
      $carousel.each(function () {
        var $c = $(this);
        var flkty = $c.data('flickity');

        if (!flkty) return;

        // ვპოულობთ სურათებს სლაიდში
        var $cells = $c.find('.slide');
        var $imgs  = $cells.find('img');

        if (!$imgs.length) return;

        // parallax-ის ფაქტორი – სურვილისამებრ შეცვლადი
        var PARALLAX_FACTOR = 0.18; // რაც უფრო დიდი, მით მეტი shift

        function updateParallax() {
          flkty.slides.forEach(function (slide, i) {
            if (!$imgs.eq(i).length) return;

            // target + x გვაძლევს სლაიდის პოზიციას
            var offset = (slide.target + flkty.x) * -PARALLAX_FACTOR;

            // scale + parallax X
            $imgs.eq(i).css('transform',
              'translateX(' + offset + 'px) scale(1.08)'
            );
          });
        }

        // scroll-ის დროს – უწყვეტი parallax
        flkty.on('scroll', updateParallax);
        // settle-ის ბოლოს ერთხელ მაინც განვაახლოთ
        flkty.on('settle', updateParallax);

        // პირველი განახლება
        updateParallax();
      });
    }, 150); // პატარა დაყოვნება, რომ Flickity სრულად ჩაირთოს

    return result;
  };
});

jQuery(function($) {

  var lastScrollTop = 0;
  var delta = 5; // პატარა ბაფერი, რომ header-ი წვრილ შერყევაზე არ რეაგირებდეს
  var $win = $(window);
  var $wrapper = $('.header-wrapper');

  // თავიდან – scroll-up მდგომარეობა
  $wrapper.addClass('scroll-up');

  $win.on('scroll', function() {
    var st = $win.scrollTop();

    // პატარა მოძრაობაზე არაფერი
    if (Math.abs(st - lastScrollTop) <= delta) {
      return;
    }

    // Scroll down და უკვე ცოტა მაინც ვართ ჩამოსულები
    if (st > lastScrollTop && st > 100) {
      // დავმალოთ sticky header
      $wrapper.removeClass('scroll-up').addClass('scroll-down');
    } else {
      // Scroll up → კვლავ გამოჩნდეს
      $wrapper.removeClass('scroll-down').addClass('scroll-up');
    }

    // გვერდის ძალიან თავში რომ ვართ, ყოველთვის გამოჩენილი იყოს
    if (st <= 0) {
      $wrapper.removeClass('scroll-down').addClass('scroll-up');
    }

    lastScrollTop = st;
  });

});

jQuery(function($){

  function pad2(n){ return String(n).padStart(2,'0'); }
  function isMobile(){ return window.matchMedia && window.matchMedia('(max-width: 849px)').matches; }

  // WrapAround index mapper to avoid shortest-path direction flips
  function mod(n, m){ return ((n % m) + m) % m; }

  // Choose a target index near current text index that matches image index (wrap-aware)
  function nearestWrappedTarget(current, target, total){
    // current: current selectedIndex on text
    // target: desired index [0..total-1]
    // We choose between target, target+total, target-total whichever is closest to current
    var a = target;
    var b = target + total;
    var c = target - total;

    var da = Math.abs(a - current);
    var db = Math.abs(b - current);
    var dc = Math.abs(c - current);

    if(db < da && db <= dc) return b;
    if(dc < da && dc <  db) return c;
    return a;
  }

  function initBeyondSlopesSlider(){
    $('.section.winter.rest').each(function(){
      var $section = $(this);
      if($section.data('brk_inited')) return;
      if(typeof $.fn.lazyFlickity !== 'function') return;

      var $imgWrap = $section.find('.slides .col-inner').first(); // cells: .img.sl
      if(!$imgWrap.length) return;

      var $textRow = $section.find('.col.slide-text').first().closest('.row');
      if(!$textRow.length) return;

      // Build track so arrows cols don't become cells
      var $textTrack = $textRow.children('.brk-text-track');
      if(!$textTrack.length){
        $textTrack = $('<div class="brk-text-track"></div>');
        var $textCols = $textRow.children('.col.slide-text');
        if(!$textCols.length) $textCols = $textRow.find('.col.slide-text');
        $textCols.appendTo($textTrack);
        $textRow.prepend($textTrack);
      }

      var $counterH3 = $section.find('.text.counter h3').first();

      // INIT Flickity
      $imgWrap.lazyFlickity({
        cellSelector: '.img.sl',
        contain: true,
        wrapAround: true,
        prevNextButtons: false,
        pageDots: false,
        draggable: true,
        imagesLoaded: true,                 // helps mobile reflow/jank
        selectedAttraction: 0.03,           // smoother
        friction: 0.28
      });

      $textTrack.lazyFlickity({
        cellSelector: '.col.slide-text',
        contain: true,
        wrapAround: true,
        prevNextButtons: false,
        pageDots: false,
        draggable: false,
        // adaptiveHeight causes reflow jank on mobile; disable there
        adaptiveHeight: !isMobile(),
        selectedAttraction: 0.04,
        friction: 0.30
      });

      $section.data('brk_imgWrap', $imgWrap);
      $section.data('brk_textTrack', $textTrack);

      function wire(){
        var imgFlkty = $imgWrap.data('flickity');
        var txtFlkty = $textTrack.data('flickity');
        if(!imgFlkty || !txtFlkty) return;

        // Prevent any accidental capture on text area
        $textTrack.on('pointerdown.flickity mousedown.flickity touchstart.flickity', function(e){
          e.preventDefault();
          e.stopPropagation();
        });

        // total slides (REAL)
        var total = $imgWrap.find('.img.sl').length;

        function updateCounter(idx){
          if(!$counterH3.length) return;
          $counterH3.html(pad2(idx + 1) + ' <span style="opacity:.4;">– ' + pad2(total) + '</span>');
        }

        // rAF-throttled sync
        var rafLock = false;
        function syncTextToImage(){
          if(rafLock) return;
          rafLock = true;
          requestAnimationFrame(function(){
            rafLock = false;

            var imgIdx = imgFlkty.selectedIndex || 0; // 0..total-1 (real)
            var txtIdx = txtFlkty.selectedIndex || 0;

            // map to nearest wrapped target (prevents shortest-path weirdness)
            var desired = nearestWrappedTarget(txtIdx, imgIdx, total);

            // IMPORTANT: flickity('select', index, isWrapped, isInstant)
            // - isWrapped: true allows selecting wrapped indices
            // - isInstant: true avoids extra animation jitter; set false if you want visible text tween
            $textTrack.flickity('select', desired, true, true);

            updateCounter(imgIdx);
          });
        }

        // initial
        updateCounter(imgFlkty.selectedIndex || 0);
        // align text instantly
        $textTrack.flickity('select', (imgFlkty.selectedIndex || 0), true, true);

        // Sync on select + settle (drag inertia)
        $imgWrap.on('select.flickity settle.flickity', syncTextToImage);

        // If you want text height to adapt but less jank, do it only after settle on desktop
        if(!isMobile()){
          $imgWrap.on('settle.flickity', function(){
            // re-measure text height once per settle
            $textTrack.flickity('resize');
          });
        }

        $section.data('brk_inited', 1);
      }

      if($imgWrap.data('flickity') && $textTrack.data('flickity')){
        wire();
      } else {
        $imgWrap.one('ready.flickity', wire);
        $textTrack.one('ready.flickity', wire);
      }
    });
  }

  // Arrows: move image only; text follows via sync
  $(document).on('click', '.section.winter.rest .slide-prev, .section.winter.rest .slide-prev *', function(e){
    e.preventDefault(); e.stopPropagation();
    var $section = $(this).closest('.section.winter.rest');
    var $imgWrap = $section.data('brk_imgWrap');
    if($imgWrap) $imgWrap.flickity('previous', true);
  });

  $(document).on('click', '.section.winter.rest .slide-next, .section.winter.rest .slide-next *', function(e){
    e.preventDefault(); e.stopPropagation();
    var $section = $(this).closest('.section.winter.rest');
    var $imgWrap = $section.data('brk_imgWrap');
    if($imgWrap) $imgWrap.flickity('next', true);
  });

  initBeyondSlopesSlider();
  $(document).on('flatsome-flickity-ready ux_builder_load', initBeyondSlopesSlider);

  // Re-init behavior on breakpoint changes (optional but helps)
  var mq = window.matchMedia && window.matchMedia('(max-width: 849px)');
  if(mq && mq.addEventListener){
    mq.addEventListener('change', function(){
      // only resize flickity instances; no full destroy needed
      $('.section.winter.rest').each(function(){
        var $section = $(this);
        var $imgWrap = $section.data('brk_imgWrap');
        var $textTrack = $section.data('brk_textTrack');
        if($imgWrap) $imgWrap.flickity('resize');
        if($textTrack) $textTrack.flickity('resize');
      });
    });
  }

});

jQuery(document).ready(function ($) {

  // Prev / Next მხოლოდ იმ სექციის სლაიდერზე, სადაც ისარია
  $(document).on('click', '.arr.resort .slide-prev, .arr.resort .slide-next', function (e) {
    e.preventDefault();

    var $btn = $(this);

    // ვპოულობთ იმავე სექციას (ყველაზე ახლოს)
    var $section = $btn.closest('.section');

    // ამ სექციის შიგნით ვპოულობთ შესაბამის flickity slider-ს
    var $slider = $section.find('.resort-slider .slider').first();

    if (!$slider.length) return;

    if ($btn.hasClass('slide-prev')) {
      $slider.flickity('previous');
    } else {
      $slider.flickity('next');
    }
  });

});


(function () {
  const spa = document.querySelector(".spa-sticky");
  if (!spa) return;

  const triggers = {
    sauna: spa.querySelector(".sauna-but"),
    massage: spa.querySelector(".massage-but"),
    gym: spa.querySelector(".gym-but"),
  };

  const slideNodes = Array.from(spa.querySelectorAll(".spa-right .img"));
  const keys = ["sauna", "massage", "gym"];
  const slides = {};

  keys.forEach((key, index) => {
    const slide = slideNodes[index];
    if (slide) {
      slide.classList.add(key);
      slides[key] = slide;
    }
  });

  const setActive = (key) => {
    const slide = slides[key];
    if (!slide) return;

    Object.values(slides).forEach((s) => s.classList.remove("active"));
    slide.classList.add("active");
  };

  Object.entries(triggers).forEach(([key, el]) => {
    if (!el) return;
    el.addEventListener("click", (e) => {
      e.preventDefault();
      setActive(key);
    });
  });

  setActive("sauna");
})();


(function () {
  if (window.innerWidth <= 768) {

    // 1. data-animate ატრიბუტების წაშლა
    document.querySelectorAll('[data-animate]').forEach(el => {
      el.removeAttribute('data-animate');
      el.removeAttribute('data-animated');
    });

    // 2. Animated კლასების მოხსნა
    document.querySelectorAll('.animated, .fadeIn, .fadeInUp, .fadeInDown, .fadeInLeft, .fadeInRight').forEach(el => {
      el.classList.remove(
        'animated',
        'fadeIn',
        'fadeInUp',
        'fadeInDown',
        'fadeInLeft',
        'fadeInRight'
      );
    });

    // 3. Inline animation styles-ის გაუქმება
    document.querySelectorAll('[style*="animation"]').forEach(el => {
      el.style.animation = 'none';
      el.style.transition = 'none';
      el.style.opacity = '1';
      el.style.transform = 'none';
    });

  }
})();

document.addEventListener('DOMContentLoaded', function () {
  const header = document.querySelector('.mobilemenu > header');
  if (!header) return;

  // თავიდანვე დავამატოთ
  header.classList.add('transparent');

  const observer = new MutationObserver(() => {
    if (!header.classList.contains('transparent')) {
      header.classList.add('transparent');
    }
  });

  observer.observe(header, {
    attributes: true,
    attributeFilter: ['class']
  });
});


document.addEventListener('DOMContentLoaded', function () {

  function isMobile48em(){
    return window.matchMedia('(max-width: 48em)').matches;
  }

  function init(){
    var $ = window.jQuery;
    if(!$) return;

    var $slider = $('.row.mobile-slider');
    if(!$slider.length) return;

    // თუ flickity plugin არ არის, მაინც OK — CSS scroll იმუშავებს
    if(!$.fn.flickity) return;

    if(isMobile48em()){
      if(!$slider.hasClass('flickity-enabled')){
        $slider.flickity({
          cellSelector: '.col',
          cellAlign: 'left',
          contain: true,
          wrapAround: true,
          prevNextButtons: true,
          pageDots: false,
          draggable: true
        });
      }
    } else {
      if($slider.hasClass('flickity-enabled')){
        $slider.flickity('destroy');
      }
    }
  }

  init();
  window.addEventListener('resize', init);
});


// ✅ MOBILE: თუ მოძრაობა ვერტიკალურია — Flickity დროებით აღარ იყოს draggable
var isMobile = window.matchMedia('(max-width: 768px)').matches;
if (isMobile && imgFlkty && imgFlkty.viewport) {
  var vp = imgFlkty.viewport;
  var sx = 0, sy = 0, locked = null;

  vp.addEventListener('touchstart', function (e) {
    var t = e.touches && e.touches[0];
    if (!t) return;
    sx = t.clientX; sy = t.clientY;
    locked = null;
    imgFlkty.isDraggable = true;
  }, { passive: true });

  vp.addEventListener('touchmove', function (e) {
    if (!imgFlkty) return;
    var t = e.touches && e.touches[0];
    if (!t) return;

    var dx = t.clientX - sx;
    var dy = t.clientY - sy;

    // მხოლოდ ერთხელ “დავล็ოკოთ” მიმართულება
    if (locked === null) {
      if (Math.abs(dy) > Math.abs(dx) + 8) {
        locked = 'vertical';
        imgFlkty.isDraggable = false; // ✅ ვერტიკალზე — გვერდის სქროლი პრიორიტეტად
      } else if (Math.abs(dx) > Math.abs(dy) + 8) {
        locked = 'horizontal';
        imgFlkty.isDraggable = true;
      }
    }
  }, { passive: true });

  vp.addEventListener('touchend', function () {
    if (imgFlkty) imgFlkty.isDraggable = true;
  }, { passive: true });
}


(function($){
  function setHeaderBookText(){
    // იღებს <html lang="ka"> / <html lang="ka-GE"> / <html lang="en">
    var lang = (document.documentElement.getAttribute('lang') || '').toLowerCase();
    var isKa = lang.indexOf('ka') === 0;

    var $span = $('.header-button-1 a.button span');
    if(!$span.length) return;

    // თუ შენი ინგლისური ტექსტი სხვაა, აქ შეცვალე
    $span.text(isKa ? 'დაჯავშნე' : 'Book');
  }

  // DOM ready
  $(setHeaderBookText);

  // თუ header გვიან იტვირთება (Flatsome sticky/header builder)
  setTimeout(setHeaderBookText, 300);
  setTimeout(setHeaderBookText, 1200);

})(jQuery);