(function ($) {
  $(function () {
    var map = {
      'tb-pin': 'tbilisi',
      'mt-pin': 'mtskheta',
      'zhi-pin': 'zhinvali',
      'ana-pin': 'ananuri',
      'pas-pin': 'pasanauri',
      'cross-mt': 'mtskheta',
      'cross-zhi': 'zhinvali',
      'cross-ana': 'ananuri',
      'cross-pas': 'pasanauri'
    };

    $('.gudauri-map .map-section').each(function () {
      var $section = $(this);
      var $baseCol = $section.find('.col.tbilisi').first();
      if (!$baseCol.length) return;
      var $baseInner = $baseCol.children('.col-inner').first();
      if (!$baseInner.length) return;

      // Keep only one overlay/pin/cross/panel set within this map instance
      function keepFirst(selector) {
        var $nodes = $section.find(selector);
        if ($nodes.length > 1) $nodes.slice(1).remove();
        return $nodes.first();
      }
      function dedupeInstance() {
        keepFirst('.map-overlay');
        keepFirst('.route-panel');
        keepFirst('.pin.pin-mt');
        keepFirst('.pin.pin-zhi');
        keepFirst('.pin.pin-ana');
        keepFirst('.pin.pin-pas');
        keepFirst('.map-cross.cross-mt');
        keepFirst('.map-cross.cross-zhi');
        keepFirst('.map-cross.cross-ana');
        keepFirst('.map-cross.cross-pas');
      }
      dedupeInstance();

      var $routes = $section.find('.col.mtskheta, .col.zhinvali, .col.ananuri, .col.pasanauri');
      var $pins = $section.find('.pins');

      var assets = window.GudauriMapAssets || {};
      var backArrowUrl = assets.backArrow || '';
      var PANEL_DURATION = 450;
      var currentRoute = 'tbilisi';

      $baseCol.addClass('is-base-route');
      $baseInner.css('position', 'relative');

      // Remove any existing panels and create a single clean one
      $baseInner.find('.route-panel').remove();
      var backLinkHtml = backArrowUrl
        ? '<button type="button" class="gm-route-back route-back" aria-label="Back to Tbilisi"><img src="' + backArrowUrl + '" alt="Back to Tbilisi" class="gm-route-back-icon route-back-icon" /></button>'
        : '<button type="button" class="gm-route-back route-back" aria-label="Back to Tbilisi">Back</button>';
      var $panel = $(
        '<div class="route-panel">' +
          backLinkHtml +
          '<button type="button" class="route-panel-close" aria-label="Close route panel">×</button>' +
          '<div class="route-panel-content"></div>' +
        '</div>'
      );
      $baseInner.append($panel);
      var $panelContent = $panel.find('.route-panel-content');
      dedupeInstance();

      function setBaseMode(isPanelOpen) {
        $baseCol.toggleClass('is-panel-open', !!isPanelOpen);
      }

      function setActivePin(routeClass) {
        $pins.removeClass('is-active');
        if (!routeClass || routeClass === 'tbilisi') {
          $section.find('.tb-pin').addClass('is-active');
          return;
        }
        $.each(map, function (pinClass, colClass) {
          if (colClass === routeClass) {
            $section.find('.' + pinClass).addClass('is-active');
          }
        });
      }

      function getRouteContent(routeClass) {
        var $col = $routes.filter('.' + routeClass).first();
        var $inner = $col.children('.col-inner').first();
        return $inner.length ? $inner.html() : '';
      }

      function showBase() {
        dedupeInstance();
        $panel.removeClass('slide-in-active slide-in-start').addClass('slide-out');
        setTimeout(function () {
          $panel.hide();
          $panelContent.empty();
          setBaseMode(false);
          setActivePin('tbilisi');
          currentRoute = 'tbilisi';
        }, PANEL_DURATION);
      }

      function showRoute(routeClass) {
        dedupeInstance();
        var html = getRouteContent(routeClass);
        if (!html) return;
        currentRoute = routeClass;
        $panelContent.empty().html(html);
        $panel.show();
        $panel.removeClass('slide-out').addClass('slide-in-start');
        void $panel[0].offsetHeight;
        $panel.addClass('slide-in-active').removeClass('slide-in-start');
        setBaseMode(true);
        setActivePin(routeClass);
      }

      $section.on('click', '.pins, .map-cross', function (e) {
        e.preventDefault();
        var routeClass = null;
        $.each(this.className.split(/\s+/), function (i, cls) {
          if (map[cls]) { routeClass = map[cls]; return false; }
        });
        if (!routeClass) return;
        if (routeClass === 'tbilisi') {
          showBase();
        } else {
          showRoute(routeClass);
        }
      });

      $section.on('click', '.route-panel-close, .gm-route-back, .route-back', function (e) {
        e.preventDefault();
        showBase();
      });

      // initial state
      showBase();
    });
  });
})(jQuery);
